from net_fft5 access *;

real net_scale = 0.4;
int gap = 75;
for (int i = 0; i < 10; ++i) {
  network N = fft5(attach_input=true, step=i, line_spacing=15);
  picture P;
  N.draw(P);
  if (i < 9) {
    real x_max = max(P).x+5, x_min = x_max - 70 - 50*(i%2);
    real y_min = min(P).y-5, y_max = max(P).y - 15 + 20*(i%2);
    if (i == 8) y_max += 20;
    draw(P, (x_min, y_min)--(x_max, y_min)--(x_max, y_max)--(x_min, y_max)--cycle, p=blue+dashed);
  }
  add(scale(net_scale)*rotate(90)*P, (gap*i, 0));
  if (i > 0) {
    real arr_x = gap*i-20, arr_y = net_scale * max(P).x / 2;
    draw((arr_x-20, arr_y-2)--(arr_x,arr_y-2), p=blue);
    draw((arr_x-20, arr_y+2)--(arr_x,arr_y+2), p=blue);
    draw((arr_x-6, arr_y-6)--(arr_x+3,arr_y)--(arr_x-6,arr_y+6), p=blue);
    label(rotate(90)*Label(i % 2 == 1 ? "(butterfly)" : "(twiddle)",
                           align = LeftSide,
                           p = blue),
          position = (arr_x, arr_y+35));
  }
}
