from net_3tensor access *;

picture P1, P2;
network N0;

tensor A = N0.add_tensor((0, 40), 10, 10, pen=green, label="$A$");
tensor B = N0.add_tensor((0, 0), 10, 10, pen=green, label="$B$");
N0.join(A.mid, B.mid);
N0.join(A.mid, A.mid + (0, 30));
N0.join(B.mid, B.mid + (0, -30));
N0.draw(P1);
label(P1, "$i$", A.mid + (5, 25), magenta+fontsize(9pt));
label(P1, "$k$", (A.mid + B.mid)/2.0 + (5, 0), magenta+fontsize(9pt));
label(P1, "$j$", B.mid + (5, -25), magenta+fontsize(9pt));

// network N1 = three_tensor();
// N1.tensors[0].label = "$\alpha$";
// N1.tensors[1].label = "$\beta$";
// N1.tensors[2].label = "$\gamma$";
// N1.draw(P1);

// label(P1, "$i'$", N1.tensors[0].mid + (-7.5, -17.5), fontsize(7pt));
// label(P1, "$k$", N1.tensors[0].mid + (7.5, -17.5), fontsize(7pt));

// label(P1, "$k'$", N1.tensors[1].mid + (-8.2, -17.5), fontsize(7pt));
// label(P1, "$j'$", N1.tensors[1].mid + (8.5, -17.5), fontsize(7pt));

// label(P1, "$i$", N1.tensors[2].mid + (-7.5, 17.5), fontsize(7pt));
// label(P1, "$j$", N1.tensors[2].mid + (7.5, 17.5), fontsize(7pt));

// label(P1, "$\ell$", (N1.tensors[0].mid + N1.tensors[1].mid + N1.tensors[2].mid) / 3 + (4,10), fontsize(7pt));


network N2 = three_tensor(attach_input=true);
N2.tensors[0].label = "$\alpha$";
N2.tensors[1].label = "$\beta$";
N2.tensors[2].label = "$\gamma$";
N2.tensors[3].label = "$A$";
N2.tensors[4].label = "$B$";
N2.draw(P2);

label(P2, "$i'$", N2.tensors[0].mid + (-7.5, -17.5), magenta+fontsize(7pt));
label(P2, "$k$", N2.tensors[0].mid + (7.5, -17.5), magenta+fontsize(7pt));

label(P2, "$k'$", N2.tensors[1].mid + (-8.2, -17.5), magenta+fontsize(7pt));
label(P2, "$j'$", N2.tensors[1].mid + (8.5, -17.5), magenta+fontsize(7pt));

label(P2, "$i$", N2.tensors[2].mid + (-7.5, 17.5), magenta+fontsize(7pt));
label(P2, "$j$", N2.tensors[2].mid + (7.5, 17.5), magenta+fontsize(7pt));

label(P2, "$\ell$", (N2.tensors[0].mid + N2.tensors[1].mid + N2.tensors[2].mid) / 3 + (4,10), magenta+fontsize(7pt));


// for (int i = 0; i < 3; ++i) {
//   int delta = i < 2 ? 7 : -7;
//   label(P1, "0", N1.tensors[i].mid + (-5, -delta), magenta+fontsize(6pt));
//   label(P1, "1", N1.tensors[i].mid + (5, -delta), magenta+fontsize(6pt));
//   label(P1, "2", N1.tensors[i].mid + (0, delta), magenta+fontsize(6pt));
// }

add(P1, (0, 0));

add(P2, (60, 0));


picture Pa, Pb, Pc;

void draw_tensor(picture P, string name, string d1, string d2, int T[][][]) {
  int x_gap=11;
  label(P, "$" + name + " =$", (-20, (7-42)/2));
  for (int i = 0; i < 2; ++i) {
    draw(P, (-3, -25*i+5)--(-5, -25*i+5)--(-5, -25*i-15)--(-3, -25*i-15));
    draw(P, (6*x_gap+3, -25*i+5)--(6*x_gap+5, -25*i+5)--(6*x_gap+5, -25*i-15)--(6*x_gap+3, -25*i-15));
    label(P, d2, (6*x_gap+8, -25*i-5), magenta+fontsize(7pt));
    for (int j = 0; j < 2; ++j)
      for (int k = 0; k < 7; ++k) {
        label(P, string(T[i][j][k]), (k*x_gap, -(25*i + 10*j)));
      }
  }
  draw(P, (-6, 7)--(-8, 7)--(-8, -42)--(-6,-42));
  draw(P, (6*x_gap+10, 7)--(6*x_gap+12, 7)--(6*x_gap+12, -42)--(6*x_gap+10,-42));
  label(P, d1, (6*x_gap+15, (7-42)/2), magenta+fontsize(7pt));
  label(P, "$\ell$", (3*x_gap, -45), magenta+fontsize(7pt));
}

int alpha[][][] = {{{1, 0, 1, 0, 1, -1, 0},
                    {0, 0, 0, 0, 1, 0, 1}},
                   {{0, 1, 0, 0, 0, 1, 0},
                    {1, 1, 0, 1, 0, 0, -1}}};
int beta[][][] = {{{1, 1, 0, -1, 0, 1, 0},
                   {0, 0, 1, 0, 0, 1, 0}},
                  {{0, 0, 0, 1, 0, 0, 1},
                   {1, 0, -1, 0, 1, 0, 1}}};
int gamma[][][] = {{{1, 0, 0, 1, -1, 0, 1},
                    {0, 0, 1, 0, 1, 0, 0}},
                   {{0, 1, 0, 1, 0, 0, 0},
                    {1, -1, 1, 0, 0, 1, 0}}};

draw_tensor(Pa, "\alpha", "$i'$", "$k$", alpha);
draw_tensor(Pb, "\beta", "$k'$", "$j'$", beta);
draw_tensor(Pc, "\gamma", "$i$", "$j$", gamma);
add(Pa, (180, 5));
add(Pc, (245, 65));
add(Pb, (310, 5));
