settings.outformat="pdf";
defaultpen(fontsize(11pt));

struct execution_node {
  pair mid;
  execution_node parent;
  bool drawn;
  
  void operator init(pair mid) {
    this.mid = mid;
    this.parent = null;
    this.drawn = false;
  }

  void draw(picture p) {
    draw(pic=p, mid, marker=marker(scale(1.2)*unitcircle,Fill, p=red));
  }
}

struct tensor {
  pair mid;
  execution_node exec;
  real width, height;
  string label;
  pen pen;

  void operator init(pair mid, real width, real height, string label="", pen pen=defaultpen) {
    this.mid = mid;
    this.exec = execution_node(mid);
    this.pen = pen;
    this.width = width;
    this.height = height;
    this.label = label;
  }

  void draw(picture p) {
    filldraw(pic=p, mid+(width,height) -- mid+(-width,height) -- mid+(-width,-height) -- mid+(width,-height) -- cycle, drawpen=pen, fillpen=white);
    if (label != "") {
      label(pic=p, label, position=mid);
    }
  }
}

struct mode_join {
  pair mid;

  void operator init(pair mid) {
    this.mid = mid;
  }

  void draw(picture p) {
    draw(pic=p, mid, marker=marker(scale(1.5)*unitcircle,Fill));
  }
}

struct network {
  tensor tensors[];
  mode_join mode_joins[];
  Label mode_labels[];
  path edges[];
  path exec_edges[];
  execution_node exec[];
  Label labels[];
  
  network sub_networks[];
  pair sub_network_shifts[];

  execution_node add_execution_node(pair mid) {
    return exec.push(execution_node(mid));
  }

  void add_sub_network(network N, pair shift=(0,0)) {
    sub_networks.push(N);
    sub_network_shifts.push(shift);
  }

  void add_label(Label L) {
    labels.push(L);
  }

  tensor add_tensor(pair mid, real width, real height, string label="", pen pen=defaultpen) {
    tensor ret = tensors.push(tensor(mid, width, height, label, pen));
    exec.push(ret.exec);
    return ret;
  }

  mode_join add_mode_join(pair mid) {
    return mode_joins.push(mode_join(mid));
  }

  void exec_join(execution_node src, execution_node dst ... pair[] control_points) {
    src.parent = dst;
    if (control_points.length == 0) {
      exec_edges.push(src.mid -- dst.mid);
    } else {
      exec_edges.push(src.mid..controls control_points[0]..dst.mid);
    }
  }

  void join(pair p1, pair p2, string label="") {
    edges.push(p1--p2);
    if (label != "") {
      pair dir = dir(p1--p2, 0);
      mode_labels.push(Label(label, position = (p1+p2)/2 + 6*(-dir.y, dir.x)));
    }
  }
  
  void add_path(path p) {
    edges.push(p);
  }

  void draw(picture pic=currentpicture, bool draw_execution=false) {
    for (int i = 0; i < sub_networks.length; ++i) {
      picture P;
      sub_networks[i].draw(pic=P, draw_execution=draw_execution);
      add(pic, P, position=sub_network_shifts[i]);
    }
    for (path p: edges) {
      draw(pic=pic, p);
    }
    for (mode_join m: mode_joins) {
      m.draw(pic);
    }
    for (tensor t: tensors) {
      t.draw(pic);
    }
    for (Label L: mode_labels) {
      label(pic, L);
    }
    for (Label L: labels) {
      label(pic, L);
    }
    if (draw_execution) {
      for (execution_node e: exec)
        e.draw(pic);
      for (path p: exec_edges)
        draw(pic=pic, p, p=red, arrow=Arrow(arrowhead=HookHead, size=4));
    }
  }
}

path smooth_vertical_path(pair s, pair t) {
  return s .. controls (s.x, (s.y+t.y)/2) and (t.x, (s.y+t.y)/2) .. t;
}

